<?php

namespace TCG\Voyager\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use TCG\Voyager\Facades\Voyager;

class Permission extends Model
{
    protected $guarded = [];

    public function roles()
    {
        return $this->belongsToMany(Voyager::modelClass('Role'));
    }

    public static function generateFor($table_name, $edit = null)
    {
        if(!$edit) {
            $permission = self::firstOrCreate(['key' => 'browse_' . $table_name, 'table_name' => $table_name]);
            self::insetPermissionRole($permission);
            $permission = self::firstOrCreate(['key' => 'read_' . $table_name, 'table_name' => $table_name]);
            self::insetPermissionRole($permission);
            $permission = self::firstOrCreate(['key' => 'edit_' . $table_name, 'table_name' => $table_name]);
            self::insetPermissionRole($permission);
            $permission = self::firstOrCreate(['key' => 'add_' . $table_name, 'table_name' => $table_name]);
            self::insetPermissionRole($permission);
            $permission = self::firstOrCreate(['key' => 'delete_' . $table_name, 'table_name' => $table_name]);
            self::insetPermissionRole($permission);
        }
    }

    public static function removeFrom($table_name)
    {
        self::where(['table_name' => $table_name])->delete();
    }

    public static function insetPermissionRole($permission){
        DB::table('permission_role')->insert(['permission_id'=>$permission->id, 'role_id'=> 1]);
    }
}
