<?php

namespace TCG\Voyager\Widgets;

use App\JobOffer;
use App\JobOfferRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use TCG\Voyager\Facades\Voyager;

class JobOfferRequestDimmer extends BaseDimmer
{
    /**
     * The configuration array.
     *
     * @var array
     */
    protected $config = [];

    /**
     * Treat this method as a controller action.
     * Return view() or other content to display.
     */
    public function run(){
        $string = " Requests";
        if(Auth::user()->employer_id != null) {
            $count = JobOfferRequest::getJobOffersRequestsCount(Auth::user()->employer_id)[0]->total;
        }else{
            $count = JobOfferRequest::count();
        }

        return view('voyager::dimmer', array_merge($this->config, [
            'icon'   => 'voyager-group',
            'title'  => "{$count} {$string}",
            'text'   => __('voyager::dimmer.job_offer_rq_text', ['count' => $count, 'string' => Str::lower($string)]),
            'button' => [
                'text' => __('voyager::dimmer.job_request_link_text'),
                'link' => route('voyager.job-offer-requests.index'),
            ],
            'image' => voyager_asset('images/widget-backgrounds/01.jpg'),
        ]));
    }


}
